<?xml version="1.0" encoding="ISO-8859-1" ?>
<jsp:root xmlns:jsp="http://java.sun.com/JSP/Page" version="2.0" xmlns:c="http://java.sun.com/jsp/jstl/core">
	<jsp:directive.page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1" />
	<jsp:text><![CDATA[ <?xml version="1.0" encoding="ISO-8859-1" ?> ]]></jsp:text>
	<jsp:text>
		<![CDATA[ <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"> ]]>
	</jsp:text>
	<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
	<title>HTTP Methods examples</title>
	<style>
a {
	text-decoration: none;
	color: black;
	font-weight: bold;
}	

a:hover {
	color: red;
}

table, body {
	font-family: Helvetica, Arial, sans-serif;
	font-size: 10pt;
}

table {
	border-collapse: collapse;
}

table, td, th, caption {
	border: 1px solid black;
}

td, th, caption {
	padding: 4px;
}
	</style>
	<c:url scope="page" value="/method" var="baseUrl" />
	<script>
function sendRequest(method, i) {

	xhr = new XMLHttpRequest();
	xhr.open(method, '${baseUrl}');
	xhr.send(null);
	xhr.onreadystatechange = function (event) {
		if (xhr.readyState == 4) {
			if(xhr.status == 200) {
				document.open();
				document.write(xhr.responseText);
				document.close(); 
			}
		}
	};
}
	</script>
	</head>
	<body>
	<table>
		<thead>
			<tr>
				<th>Description</th>
				<th>Action</th>
				<th>Method</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>Form GET</td>
				<td>
					<form action="${baseUrl}" method="GET">
						<input type="hidden" name="i" value="0" />
						<input type="submit"/>
					</form>
				</td>
				<td><c:out value="${sessionScope.methods[0]}" /></td>
			</tr>
			<tr>
				<td>Form POST</td>
				<td>
					<form action="${baseUrl}" method="POST">
						<input type="hidden" name="i" value="1" />
						<input type="submit"/>
					</form>
				</td>
				<td><c:out value="${sessionScope.methods[1]}" /></td>
			</tr>
			<tr>
				<td>Form PUT</td>
				<td>
					<form action="${baseUrl}" method="PUT">
						<input type="hidden" name="i" value="2" />
						<input type="submit"/>
					</form>
				</td>
				<td><c:out value="${sessionScope.methods[2]}" /></td>
			</tr>
			<tr>
				<td>Form DELETE</td>
				<td>
					<form action="${baseUrl}" method="DELETE">
						<input type="hidden" name="i" value="3" />
						<input type="submit"/>
					</form>
				</td>
				<td><c:out value="${sessionScope.methods[3]}" /></td>
			</tr>
			<tr>
				<td>Ajax PUT</td>
				<td>
					<input type="submit" onclick="sendRequest('PUT')" />
				</td>
				<td><c:out value="${sessionScope.methods[4]}" /></td>
			</tr>
			<tr>
				<td>Ajax DELETE</td>
				<td>
					<input type="submit" onclick="sendRequest('DELETE')" />
				</td>
				<td><c:out value="${sessionScope.methods[5]}" /></td>
			</tr>
			<tr>
				<td>Ajax 
					<c:choose>
						<c:when test="${sessionScope.methods[6]} not null">
							<input type="text" id="method"  value="${sessionScope.methods[6]}" />
						</c:when>
						<c:otherwise>
							<input type="text" id="method"  value="FooBar" />
						</c:otherwise>
					</c:choose>
				</td>
				<td>
					<input type="submit" onclick="sendRequest(document.getElementById('method').value)" />
				</td>
				<td><c:out value="${sessionScope.methods[6]}" /></td>
			</tr>
		</tbody>
		<tfoot>
			<tr>
				<c:url scope="page" value="/invalidate" var="invalidateUrl" />
				<td colspan="3"><a href="${invalidateUrl}">Invalidate session</a></td>
			</tr>		
		</tfoot>
	</table>
	</body>
	</html>
</jsp:root>